/*
 * Fabric Management Agent
 *
 * One runs on each Myrinet node and communicates with the fabric
 * management server(s).
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "libfma.h"

#include "fma.h"

/*
 * Print the error stack
 */
void
fma_perror()
{
  lf_string_t s;
  int off;
  int i;

  for (i=0; i<A.error_index; ++i) {
    off = sprintf(s, "%s:%d %s", A.error_file[i], A.error_line[i],
            A.error_str[i]);
    if (A.error_errno[i] != 0) {
      off += sprintf(s+off, ": %s", strerror(A.error_errno[i]));
    }
    fma_log(s);
  }

  fma_reset_error();
}

void
fma_reset_error()
{
  A.error_index = 0;
}

/* combo */
void
fma_perror_exit(
  int code)
{
  fma_perror();
  abort();		/* XXX */
  fma_exit(code);
}

/*
 * Save away an error string
 */
void
fma_save_error(
  char *file,
  int lineno,
  int err_no,
  char *errstr)
{
  /* Save the message */
  if (A.error_index >= (FMA_MAX_ERROR_DEPTH-1)) {
    strncpy(A.error_str[FMA_MAX_ERROR_DEPTH-1], "Error depth overflow",
	FMA_MAX_ERROR_LEN);
    A.error_index = FMA_MAX_ERROR_DEPTH;
  } else {
    A.error_file[A.error_index] = file;
    A.error_line[A.error_index] = lineno;
    A.error_errno[A.error_index] = err_no;

    /* error_str[] is declared with FMA_MAX_ERROR_LEN+1 to force null-term */
    strncpy(A.error_str[A.error_index++], errstr, FMA_MAX_ERROR_LEN);
  }					
}
